<?php
date_default_timezone_set('UTC');

error_reporting(E_ALL);

include_once(dirname(__FILE__) . "/src/Ifsnop/Mysqldump/Mysqldump.php");

use Ifsnop\Mysqldump as IMysqldump;

try {
    $dumpSettings = array();
    $dumpSettings['compress'] = IMysqldump\Mysqldump::GZIP;
    // $dumpSettings['exclude-tables'][] = 'tbldfu_cust_communication_old';
    $dumpSettings['include-tables'][] = 'tbldfu_cust_communication';
    $dumpSettings['include-tables'][] = 'tbldt_auto_email_recipient_archive';
    $dumpSettings['include-tables'][] = 'tbldfu_copyright';
    $dump = new IMysqldump\Mysqldump('mysql:host=localhost;dbname=studiopr_sprosnew', 'studiopr_spdbuse', '-Z5]W[A55wJU', $dumpSettings);

    $dump->setTableWheres(array(
        'tbldfu_cust_communication' => 'schedule_date > NOW() - INTERVAL 1 DAY',
        'tbldt_auto_email_recipient_archive' => 'mail_send_date > NOW() - INTERVAL 1 DAY',
        'tbldfu_copyright' => 'cdated > NOW() - INTERVAL 1 DAY',
        // 'users' => 'date_registered > NOW() - INTERVAL 3 MONTH AND deleted=0',
        // 'logs' => 'date_logged > NOW() - INTERVAL 1 DAY',
        // 'posts' => 'isLive=1'
    ));
    $file_name = 'big_data_'.date('d-m-Y').'.sql.gz';
    $file_path = "/home/studiopr/backup/mysqldump/storage/work/big_data_table_per_day/".$file_name;
    $dump->start($file_path);
} catch (\Exception $e) {
    echo 'mysqldump-php error: ' . $e->getMessage();
}


try {
    $dumpSettings = array();
    $dumpSettings['compress'] = IMysqldump\Mysqldump::GZIP;
    $dumpSettings['exclude-tables'][] = 'tbldfu_cust_communication_old';
    $dumpSettings['no-data'][] = 'tbldfu_cust_communication';
    $dumpSettings['no-data'][] = 'tbldt_auto_email_recipient_archive';
    $dumpSettings['no-data'][] = 'tbldfu_copyright';
    $dump = new IMysqldump\Mysqldump('mysql:host=localhost;dbname=studiopr_sprosnew', 'studiopr_spdbuse', '-Z5]W[A55wJU', $dumpSettings);


    $file_name = 'rest_data_'.date('d-m-Y').'.sql.gz';
    $file_path = "/home/studiopr/backup/mysqldump/storage/work/rest_data_table_per_day/".$file_name;
    $dump->start($file_path);
} catch (\Exception $e) {
    echo 'mysqldump-php error: ' . $e->getMessage();
}