<?php
/* 
 * Backup script to create full using mysqldump
 * 
 * @author Vikas Shrama <rightmentor@gamil.com>
 */
date_default_timezone_set('UTC');

error_reporting(E_ALL);

include_once(dirname(__FILE__) . "/src/Ifsnop/Mysqldump/Mysqldump.php");

use Ifsnop\Mysqldump as IMysqldump;

//MySQL user for backups
$username = "root";
$password = "";

//folder to store backups
$backupFolder = "backup";

//number of backups (days) to keep (including today's backup)
$numberOfBackups = 7;

//period in hours to create incremental backups
$diffBackupPeriod = 3;

//backup script path
$backupScript = "innobackupex";

//remove trailing slash
if (substr($backupFolder, -1) == "/") {
        $backupFolder = substr($backupFolder, 0, -1);
}

$backupFolderToday = $backupFolder."/".date("Y-m-d");

//check if todayi's backup folder exists
if (!file_exists($backupFolderToday)) {
        mkdir($backupFolderToday);
}

if (file_exists($backupFolderToday."/full")) {

        //create diff backup
       // if ((date("G")%$diffBackupPeriod) == 0 AND date("G") > 0) {

               echo $currentBackupFolder = $backupFolderToday."/".date("H");

                if (file_exists($currentBackupFolder)) die("The current backup already exists\n"); //stop if backup already exists
				
				//get folder of last incremental backup (or of the full backup if no incremental backup exists)
				$lastBackup = "full";
				foreach (scandir($backupFolderToday) as $file) {

				        if (substr($file, 0, 1) == ".") continue;
				        if (!is_dir($file)) continue;
				        if (((int) $file) != $file) continue;
				        if ($file == "full") continue;

				        $lastBackup = $file;

				}
                $lastBackupFolder = $backupFolderToday."/".$lastBackup.'.sql.gz';
                
                    try {
                        $dumpSettings = array();
                        $dumpSettings['compress'] = IMysqldump\Mysqldump::GZIP;
                        $dumpSettings['exclude-tables'][] = 'tbldfu_cust_communication_old';
                        $dump = new IMysqldump\Mysqldump('mysql:host=localhost;dbname=studiopr_sprosnew', 'studiopr_spdbuse', '-Z5]W[A55wJU', $dumpSettings);
                    
                        $dump->setTableWheres(array(
                            'tbldfu_cust_communication' => 'schedule_date > NOW() - INTERVAL 1 YEAR',
                            'tbldt_auto_email_recipient_archive' => 'mail_send_date > NOW() - INTERVAL 1 YEAR',
                            'tbldfu_copyright' => 'cdated > NOW() - INTERVAL 1 YEAR',
                        ));
                        $dump->start($lastBackupFolder);
                    } catch (\Exception $e) {
                        echo 'mysqldump-php error: ' . $e->getMessage();
                    }
        //}

} else {

        //create full backup
        echo $currentBackupFolder = "/home/studiopr/public_html/mysqldump/storage/work/full_one_year/full_str_backup.sql.gz";
        
        try {
            $dumpSettings = array();
            $dumpSettings['compress'] = IMysqldump\Mysqldump::GZIP;
            $dumpSettings['exclude-tables'][] = 'tbldfu_cust_communication_old';
            // $dumpSettings['exclude-tables'][] = 'tbldfu_copyright';
            $dump = new IMysqldump\Mysqldump('mysql:host=localhost;dbname=studiopr_sprosnew', 'studiopr_spdbuse', '-Z5]W[A55wJU', $dumpSettings);
        
            $dump->setTableWheres(array(
                'tbldfu_cust_communication' => 'schedule_date > NOW() - INTERVAL 1 YEAR',
                'tbldt_auto_email_recipient_archive' => 'mail_send_date > NOW() - INTERVAL 1 YEAR',
                'tbldfu_copyright' => 'cdated > NOW() - INTERVAL 1 YEAR',
                'tbldfu_assigned_mode_task_completed' => 'dateadded > NOW() - INTERVAL 1 YEAR',
                'tbldfu_assigned_mode_task_report' => 'add_date > NOW() - INTERVAL 1 YEAR',
                'tbldfu_cookie_referral' => 'date_added > NOW() - INTERVAL 1 YEAR',
            ));
            $dump->start($currentBackupFolder);
        } catch (\Exception $e) {
            echo 'mysqldump-php error: ' . $e->getMessage();
        }
        
        echo "Create full backup (".$currentBackupFolder.")\n";
}





//remove old backups
$todayTS = mktime(0,0,0);
$lastValidTS = $todayTS-($numberOfBackups*(60*60*24));

foreach (scandir($backupFolder) as $folder) {

        //skip hidden files and folders
        if (substr($folder, 0, 1) == ".") continue;

        //get timestamp for backup from folder name
        $folderTS = strtotime($folder);

        //skip files and folders with invalid timestamps
        if ($folderTS == 0) continue;

        //skip up-to-date backups
        if ($folderTS > $lastValidTS) continue;

        //delete old backup
        echo 'Delete old backup '.$folder."\n";
        shell_exec("rm -R ".$backupFolder."/".$folder);

}