<?php
global $spdb;

class SPDB {

   public $insert_id;

   public $last_query;

   public $last_error;
   
   public $result;

   public $last_result;

   public $rows_affected;

   public $num_rows;

   public $process_fields;

   public $query;

   public $prepare;

   public $prefix;


   /**
    * Class constructor.
    */

   public function __construct() {

      $this->prefix = 'wp_';

   }

   /**
    * Get Results
    * 
    */


   public function get_results( $sql ){

      global $spconnect;

      try{

         $this->last_query = $sql;

         $result = mysqli_query($spconnect, $sql);
   
         $num_rows = 0;
         $last_result = array();
   
         while ( $row = mysqli_fetch_object( $result ) ) {
   
            $last_result[ $num_rows ] = $row;
            ++$num_rows;
   
         }
   
         return $response =  $last_result;

      } catch (\Throwable $th) {

         echo $this->last_error = mysqli_error($spconnect);

         //echo mysqli_error($spconnect);

         return [];
      
      }

      
   }

   public function get_row( $sql ) {

		
      global $spconnect;

      $num_rows = 0;
      $last_result = array();

      try {
         //code...
         $this->last_query = $sql;

         $result = mysqli_query($spconnect, $sql);

         while ( $row = mysqli_fetch_object( $result ) ) {
   
            $last_result[ $num_rows ] = $row;
            ++$num_rows;
            continue;
   
         }
   
         return $response =  $last_result[0];

      } catch (\Throwable $th) {

         //echo mysqli_error($spconnect);

         echo $this->last_error = mysqli_error($spconnect);

         return [];
        
      }
      
	}

   public function insert( $table, $data, $format = null ) {
     global $spconnect;
      $this->insert_id = 0;

      $formats = array();
      $values  = array();

      foreach ( $data as $value ) {

         if ( is_null( $value ) ) {

            $formats[] = 'NULL';
            continue;

         }

         $formats[] = $this->field_escape_string($value);

      }

      $fields  = '`' . implode( '`, `', array_keys( $data ) ) . '`';

      $formats = implode( ', ', $formats );

      try {

         $sql = "INSERT INTO `$table` ($fields) VALUES ($formats)"; //die('query');
      
         return $this->query( $sql );

      } catch (\Throwable $th) {

         echo mysqli_error($spconnect);

         return [];
        
      }
   

   }

   public function update( $table, $data, $where, $format = null ) {
      global $spconnect;
      if ( ! is_array( $data ) || ! is_array( $where ) ) {

         return false;

      }

      $fields     = array();
      $conditions = array();

      foreach ( $data as $field => $value ) {

         if ( is_null( $value ) ) {
            $fields[] = "`$field` = NULL";
            continue;
         }

         $fields[] = "`$field` = " . $this->field_escape_string($value);

      }

      foreach ( $where as $field => $value ) {

         if ( is_null( $value ) ) {

            $conditions[] = "`$field` IS NULL";
            continue;

         }

         $conditions[] = "`$field` = " . $this->field_escape_string($value);

      }

      $fields     = implode( ', ', $fields );
      $conditions = implode( ' AND ', $conditions );

      $sql = "UPDATE `$table` SET $fields WHERE $conditions";

      try {

         return $this->query( $sql );

      } catch (\Throwable $th) {

         echo mysqli_error($spconnect);


         return [];
        
      }


      
   }

   public function delete( $table, $where ) {
    global $spconnect;
      if ( ! is_array( $where ) ) {
         return false;
      }

      $conditions = array();
      $values     = array();

      foreach ( $where as $field => $value ) {

         if ( is_null( $value ) ) {

            $conditions[] = "`$field` IS NULL";
            continue;
            
         }

         $conditions[] = "`$field` = " . $this->field_escape_string($value);;
         
      }

      $conditions = implode( ' AND ', $conditions );

      $sql = "DELETE FROM `$table` WHERE $conditions";

      try {
         
         return $this->query( $sql );

      } catch (\Throwable $th) {

         echo mysqli_error($spconnect);

         return [];
        
      }

   }

   public function query($query){

      global $spconnect;

      if($spconnect){        

         if( $result = mysqli_query($spconnect, $query) ){

            //echo '<pre>';print_r($result);echo '</pre>';

            $this->result = $result;

            $this->last_query = $query;

            if ( preg_match( '/^\s*(create|alter|truncate|drop)\s/i', $query ) ) {

               $return_val = $this->result;

            } elseif ( preg_match( '/^\s*(insert|delete|update|replace)\s/i', $query ) ) {

               $this->rows_affected = mysqli_affected_rows( $spconnect );
      
               // Take note of the insert_id.
               if ( preg_match( '/^\s*(insert|replace)\s/i', $query ) ) {

                  $this->insert_id = mysqli_insert_id( $spconnect );

               }
      
               // Return number of rows affected.
               $return_val = $this->rows_affected;

            } else {

               $num_rows = 0;
      
               if ( $this->result instanceof mysqli_result ) {

                  while ( $row = mysqli_fetch_object( $this->result ) ) {

                     $this->last_result[ $num_rows ] = $row;
                     ++$num_rows;

                  }

               }

               
      
               // Log and return the number of rows selected.
               $this->num_rows = $num_rows;
               $return_val = $this->last_result;
               

            }
      
            return $return_val;


         }else{
            $this->last_error = mysqli_error($spconnect);
         }

         /*
         try{

            $this->result = $result;

            $this->last_query = $query;

            if ( preg_match( '/^\s*(create|alter|truncate|drop)\s/i', $query ) ) {

               $return_val = $this->result;

            } elseif ( preg_match( '/^\s*(insert|delete|update|replace)\s/i', $query ) ) {

               $this->rows_affected = mysqli_affected_rows( $spconnect );
      
               // Take note of the insert_id.
               if ( preg_match( '/^\s*(insert|replace)\s/i', $query ) ) {

                  $this->insert_id = mysqli_insert_id( $spconnect );

               }
      
               // Return number of rows affected.
               $return_val = $this->rows_affected;

            } else {

               $num_rows = 0;
      
               if ( $this->result instanceof mysqli_result ) {

                  while ( $row = mysqli_fetch_object( $this->result ) ) {

                     $this->last_result[ $num_rows ] = $row;
                     ++$num_rows;

                  }

               }

               
      
               // Log and return the number of rows selected.
               $this->num_rows = $num_rows;
               $return_val = $this->last_result;
               

            }
      
            return $return_val;
   
         } catch (\Throwable $th) {
   
            $this->last_error = mysqli_error($spconnect);
   
            return [];
         
         }
         */

      }else{

         $this->last_error = "Database Connection Error!";

      }

   }

   public function field_escape_string($str){

      global $spconnect;
      
      return ($str != '') ? '\'' . mysqli_real_escape_string($spconnect, $str) . '\'' : 'NULL';

   }


   
}
$spdb = new SPDB();


function get_featured_img($post_id){
   
   global $spdb;
   
   $featured_image = '';

   $media = $spdb->get_row("SELECT * FROM wp_media WHERE post_id = '$post_id' AND media_type= 'featured_image' ");
   if( !empty( $media ) ){

         $image = $media->path;

         if( !empty( $image ) ){

            $featured_image = $image;
            
         }

   }
   return $featured_image;
}

function getSimpleValue($sql){
   $rs  = gmysql_query($sql);
   $row = mysqli_fetch_array($rs);
   return $row[0];
}

function getSimpleValues($sql){  
   $rs = gmysql_query($sql);
   $row = mysqli_fetch_array($rs);
   if ($rs->num_rows > 0) {
      return $row;
   } else {
      return false;
   }
}

function getList($sql){
   $i = 0;
   $rs = gmysql_query($sql);
   $values = array();
   while (($row = mysqli_fetch_array($rs)))
      $values[$i++] = $row[0];
   return $values;
}

function getListDetailed($sql){
   $i = 0;
   //$$values = array();
   $values = array();
   $rs = gmysql_query($sql);
   while (($row = mysqli_fetch_array($rs, MYSQLI_ASSOC)))
      $values[$i++] = $row;
   return $values;
}

function safe($value){
    global $spconnect;
   return mysqli_real_escape_string($spconnect, $value);
}

if(!function_exists('array_random_assoc')){
   function array_random_assoc($arr, $num = 1) {
      if(!empty($_SESSION['red_id'])){
         unset($arr[$_SESSION['red_id']]);
      }
      $keys = array_keys($arr);
      shuffle($keys);
      $r = array();
      for ($i = 0; $i < $num; $i++) {
         $r[$keys[$i]] = $arr[$keys[$i]];
      }
      return $r;
   }
}

/**
 * create seo url by string
 */
function createSEOURL($string) {
   // Remove special characters and spaces
   $string = preg_replace('/[^a-zA-Z0-9]/', ' ', $string);

   // Convert to lowercase and trim
   $string = strtolower(trim($string));

   // Replace spaces with dashes
   $string = preg_replace('/\s+/', '-', $string);

   // Remove multiple dashes
   $string = preg_replace('/-+/', '-', $string);

   // Remove leading and trailing dashes
   $string = trim($string, '-');

   return $string;
}

/**
 * create seo slug with max length
 */
function sp_slug($string, $maxLength = 100000000000000) {
   // Remove special characters and spaces
   $string = preg_replace('/[^a-zA-Z0-9]/', ' ', $string);

   // Convert to lowercase and trim
   $string = strtolower(trim($string));

   // Replace spaces with dashes
   $string = preg_replace('/\s+/', '-', $string);

   // Remove multiple dashes
   $string = preg_replace('/-+/', '-', $string);

   // Remove leading and trailing dashes
   $string = trim($string, '-');

   // Truncate to the specified maximum length
   if (strlen($string) > $maxLength) {
       $string = substr($string, 0, $maxLength);
   }

   return $string;

}

function pun_trim($str) {
   // Use a regular expression to remove leading and trailing whitespace
   $trimmedStr = preg_replace('/^\s+|\s+$/u', '', $str);
   return $trimmedStr;
}

function pun_hash($str){
	return sha1($str);
}

function get_ip(){
   if(isset($_SERVER['HTTP_X_FORWARDED_FOR']) && !empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
      $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
   }else{
      $ip = $_SERVER['REMOTE_ADDR'];
   }  
   return $ip;
}

function htmlsafeStr($str) {
	return htmlentities($str, ENT_QUOTES);
}


function validatePassword($password){
   $return = [];
   // Minimum length requirement
   $minLength = 6;
   // Maximum length requirement
   $maxLength = 15;
   // Check if the password meets the minimum length requirement
   if(strlen($password) < $minLength){
      $return['status']    =  false;
      $return['message']   =  "Password must be at least $minLength characters long.";
      return $return;
   }
   // Check if the password exceeds the maximum length requirement
   if(strlen($password) > $maxLength){
      $return['status']    =  false;
      $return['message']   =  "Password must not exceed $maxLength characters.";
      return $return;
   }
   // Check for any additional criteria such as containing uppercase, lowercase, digits, and special characters
   if(!preg_match('/[A-Z]/', $password) || !preg_match('/[a-z]/', $password) || !preg_match('/[0-9]/', $password) || !preg_match('/[!@#$%^&*()\-_=+{};:,<.>]/', $password)){
      $return['status']    =  false;
      $return['message']   =  "Password must contain at least one uppercase letter, one lowercase letter, one number digit and one special character.";
      return $return;
   }
   $return['status']     =    true;
   $return['message']    =    "VALID";
   return $return;
}

/**
 * PAGINATION FUNCTION
 */
function spblog_pagination($total_pages, $current_page, $base_url,$parse_url){
   $pagination = '';
   if(!empty($total_pages)){

      //$var = parse_url($parse_url);
      //echo '<pre>';print_r($var);echo '</pre>';

      $pagination .= '<div class="pagination">';
      
      // Parse the URL
      $urlParts = ( $parse_url ) ? parse_url($parse_url) : '';
      // Check if query string exists
      if( !empty( $parse_url ) && isset( $urlParts['query'] ) ){
         $sep = '?'.$urlParts['query'];
      }else{
         $sep = '/';
      }
      // First page
      if($current_page > 2){
         $pagination .= '<a href="' . $base_url . '/' .'1' . $sep. '">First</a>';
         if($current_page > 3){
            $pagination .= '<span>...</span>';
         }
      }

      // Previous page
      if($current_page > 1){
          $prev_page = $current_page - 1;
          $pagination .= '<a href="' . $base_url .'/' . $prev_page . $sep . '' . '">Prev</a>';
      }

      // Middle pages
      for($i = max(1, $current_page - 2); $i <= min($current_page + 2, $total_pages); $i++){
         if($i == $current_page){
            $pagination .= '<span class="active-p">' . $i . '</span>';
         }else{
            $pagination .= '<a href="' . $base_url .'/' . $i . $sep . ''. '">' . $i . '</a>';
         }
      }
      // Next page
      if($current_page < $total_pages){
         $next_page = $current_page + 1;
         $pagination .= '<a href="' . $base_url .'/' . $next_page . $sep . '' . '">Next</a>';
      }
      // Last page
      if($current_page < $total_pages - 1){
         if($current_page < $total_pages - 2){
            $pagination .= '<span>...</span>';
         }
         $pagination .= '<a href="' . $base_url . '/' . $total_pages . $sep . '' . '">Last</a>';
      }

      $pagination .= '</div>';
      
   }
   return $pagination;
}


/**
 * Function to validate a username
 */
function validateUsername($username){
   $return = [];
   // Minimum and maximum length for the username
   $minLength = 6;
   $maxLength = 20;
   // Regular expression to check for valid characters (letters, numbers, underscore)
   $regex = '/^[a-zA-Z0-9_]+$/';
   // Check if the username meets the length criteria
   if(strlen($username) < $minLength || strlen($username) > $maxLength){

      $return['status']    =  false;
      $return['message']   =  "Username must be between $minLength and $maxLength characters long.";

   }else if(!preg_match($regex, $username)){  // Check if the username contains only valid characters

      $return['status']    =  false;
      $return['message']   =  "Username can only contain letters, numbers, and underscores.";

   }else{ // If validation passes, return true

      $return['status']    =  true;
      $return['message']   =  "";

   }

   return $return;
}

function generateRandomString($length = 10) {
   $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
   $randomString = substr(str_shuffle($characters), 0, $length);

   return $randomString;
}

function generateSlugWithEmojis($title, $existingSlugs) {
   /* echo '<pre>';print_r($title);echo '</pre>';
   echo '<pre>';print_r($existingSlugs);echo '</pre>';
   die; */
   // Step 1: Sanitize the title
   // Remove unwanted characters but keep emojis, letters, numbers, spaces, and hyphens
   $slug = preg_replace('/[^\p{L}\p{N}\s\-\x{1F600}-\x{1F64F}\x{1F300}-\x{1F5FF}\x{1F680}-\x{1F6FF}]+/u', '', $title);
   $slug = preg_replace('/\s+/', '-', trim($slug)); // Replace spaces with hyphens
   $slug = mb_strtolower($slug); // Convert to lowercase

   // Step 2: Ensure uniqueness
   $originalSlug = $slug;
   $counter = 1;
   while ( in_array( $slug, $existingSlugs )) {
      $slug = $originalSlug . '-' . $counter;
      $counter++;
   }

   return rawurlencode( $slug );
}
function getPostSlug($url, $projectName) {
   // Parse the URL to extract the path
   $parsedUrl = parse_url($url);
   $path = $parsedUrl['path']; // Get the path part of the URL

   // Remove the project name from the path
   $path = str_replace("/$projectName/", '', $path);

   // Return the last part of the path as the slug
   return trim($path, '/');
}
?>